/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.platform.plugin;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.GroupingUtils;
import mod.chiselsandbits.platforms.core.plugin.IPlatformPluginManager;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public final class FabricPluginManager
implements IPlatformPluginManager {
    private static final FabricPluginManager INSTANCE = new FabricPluginManager();

    public static FabricPluginManager getInstance() {
        return INSTANCE;
    }

    private FabricPluginManager() {
    }

    @Override
    public <A, I extends Annotation, T> Collection<T> loadPlugins(Class<A> annotationType, Class<I> instanceAnnotationType, Class<T> pluginSpecificationType, Function<T, String> idExtractor) {
        List plugins = FabricLoader.getInstance().getEntrypointContainers("chiselsandbits:plugin", pluginSpecificationType).stream().map(EntrypointContainer::getEntrypoint).collect(Collectors.toList());
        Collection groupedByIds = GroupingUtils.groupByUsingSet(plugins, idExtractor);
        Collection idsWithDuplicates = groupedByIds.stream().filter(p -> p.size() > 1).map(p -> p.iterator().next()).map(idExtractor).collect(Collectors.toSet());
        if (idsWithDuplicates.size() > 0) {
            throw new RuntimeException(String.format("Can not load C&B there are multiple instances of the plugins: [%s]", String.join((CharSequence)", ", idsWithDuplicates)));
        }
        return ImmutableSet.copyOf(plugins);
    }
}

